﻿using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace Inet.Viewer.Helper
{
    [TestFixture]
    class TestStringTokenizer
    {

        [Test]
        public void TestTokensWithDelimiter()
        {
            string strToCheck = "Test&FirstParam=FirstValue&SecondParam=SecondValue";
            Inet.Viewer.Helper.StringTokenizer t = new Inet.Viewer.Helper.StringTokenizer(strToCheck, "&=", true);            
            
            string[] result = new string[100];
            int i = 0;
            while (t.HasMore())
            {              
                result[i] = t.Next();
                i++;                           
            }
            Assert.AreEqual("&", result[1]);
            Assert.AreEqual("FirstParam", result[2]);
            Assert.AreEqual("=", result[3]);
            Assert.AreEqual("FirstValue", result[4]);
            Assert.AreEqual("&", result[5]);
            Assert.AreEqual("SecondParam", result[6]);
            Assert.AreEqual("=", result[7]);
            Assert.AreEqual("SecondValue", result[8]);
        }

        [Test]
        public void TestTokensWithDelimiterIncomplete()
        {
            string strToCheck = "Test&FirstParam&SecondParam=SecondValue";
            Inet.Viewer.Helper.StringTokenizer t = new Inet.Viewer.Helper.StringTokenizer(strToCheck, "&=", true);

            string[] result = new string[100];
            int i = 0;
            while (t.HasMore())
            {
                result[i] = t.Next();
                i++;
            }
            Assert.AreEqual("&", result[1]);
            Assert.AreEqual("FirstParam", result[2]);      
            Assert.AreEqual("&", result[3]);
            Assert.AreEqual("SecondParam", result[4]);
            Assert.AreEqual("=", result[5]);
            Assert.AreEqual("SecondValue", result[6]);
        }
    }
}
